/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.PositionedRectangle;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import net.minecraft.resources.ResourceLocation;

public class NinePatchRenderer {
    private final ResourceLocation texture;
    private final int u;
    private final int v;
    private final Size cornerPatchSize;
    private final Size centerPatchSize;
    private final Size textureSize;
    private final boolean repeat;

    public NinePatchRenderer(ResourceLocation texture, int u, int v, Size cornerPatchSize, Size centerPatchSize, Size textureSize, boolean repeat) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.textureSize = textureSize;
        this.cornerPatchSize = cornerPatchSize;
        this.centerPatchSize = centerPatchSize;
        this.repeat = repeat;
    }

    public NinePatchRenderer(ResourceLocation texture, int u, int v, Size patchSize, Size textureSize, boolean repeat) {
        this(texture, u, v, patchSize, patchSize, textureSize, repeat);
    }

    public NinePatchRenderer(ResourceLocation texture, Size patchSize, Size textureSize, boolean repeat) {
        this(texture, 0, 0, patchSize, textureSize, repeat);
    }

    public void draw(PoseStack matrices, PositionedRectangle rectangle) {
        this.draw(matrices, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height());
    }

    public void draw(PoseStack matrices, int x, int y, int width, int height) {
        Drawer.recordQuads();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        int rightEdge = this.cornerPatchSize.width() + this.centerPatchSize.width();
        int bottomEdge = this.cornerPatchSize.height() + this.centerPatchSize.height();
        Drawer.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)this.u, (float)this.v, (int)this.cornerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        Drawer.m_93133_((PoseStack)matrices, (int)(x + width - this.cornerPatchSize.width()), (int)y, (float)(this.u + rightEdge), (float)this.v, (int)this.cornerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        Drawer.m_93133_((PoseStack)matrices, (int)x, (int)(y + height - this.cornerPatchSize.height()), (float)this.u, (float)(this.v + bottomEdge), (int)this.cornerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        Drawer.m_93133_((PoseStack)matrices, (int)(x + width - this.cornerPatchSize.width()), (int)(y + height - this.cornerPatchSize.height()), (float)(this.u + rightEdge), (float)(this.v + bottomEdge), (int)this.cornerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        if (this.repeat) {
            this.drawRepeated(matrices, x, y, width, height);
        } else {
            this.drawStretched(matrices, x, y, width, height);
        }
        Drawer.submitQuads();
    }

    protected void drawStretched(PoseStack matrices, int x, int y, int width, int height) {
        int doubleCornerHeight = this.cornerPatchSize.height() * 2;
        int doubleCornerWidth = this.cornerPatchSize.width() * 2;
        int rightEdge = this.cornerPatchSize.width() + this.centerPatchSize.width();
        int bottomEdge = this.cornerPatchSize.height() + this.centerPatchSize.height();
        if (width > doubleCornerWidth && height > doubleCornerHeight) {
            Drawer.m_93160_((PoseStack)matrices, (int)(x + this.cornerPatchSize.width()), (int)(y + this.cornerPatchSize.height()), (int)(width - doubleCornerWidth), (int)(height - doubleCornerHeight), (float)(this.u + this.cornerPatchSize.width()), (float)(this.v + this.cornerPatchSize.height()), (int)this.centerPatchSize.width(), (int)this.centerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        }
        if (width > doubleCornerWidth) {
            Drawer.m_93160_((PoseStack)matrices, (int)(x + this.cornerPatchSize.width()), (int)y, (int)(width - doubleCornerWidth), (int)this.cornerPatchSize.height(), (float)(this.u + this.cornerPatchSize.width()), (float)this.v, (int)this.centerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
            Drawer.m_93160_((PoseStack)matrices, (int)(x + this.cornerPatchSize.width()), (int)(y + height - this.cornerPatchSize.height()), (int)(width - doubleCornerWidth), (int)this.cornerPatchSize.height(), (float)(this.u + this.cornerPatchSize.width()), (float)(this.v + bottomEdge), (int)this.centerPatchSize.width(), (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        }
        if (height > doubleCornerHeight) {
            Drawer.m_93160_((PoseStack)matrices, (int)x, (int)(y + this.cornerPatchSize.height()), (int)this.cornerPatchSize.width(), (int)(height - doubleCornerHeight), (float)this.u, (float)(this.v + this.cornerPatchSize.height()), (int)this.cornerPatchSize.width(), (int)this.centerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
            Drawer.m_93160_((PoseStack)matrices, (int)(x + width - this.cornerPatchSize.width()), (int)(y + this.cornerPatchSize.height()), (int)this.cornerPatchSize.width(), (int)(height - doubleCornerHeight), (float)(this.u + rightEdge), (float)(this.v + this.cornerPatchSize.height()), (int)this.cornerPatchSize.width(), (int)this.centerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
        }
    }

    protected void drawRepeated(PoseStack matrices, int x, int y, int width, int height) {
        int drawHeight;
        int leftoverHeight;
        int doubleCornerHeight = this.cornerPatchSize.height() * 2;
        int doubleCornerWidth = this.cornerPatchSize.width() * 2;
        int rightEdge = this.cornerPatchSize.width() + this.centerPatchSize.width();
        int bottomEdge = this.cornerPatchSize.height() + this.centerPatchSize.height();
        if (width > doubleCornerWidth && height > doubleCornerHeight) {
            for (leftoverHeight = height - doubleCornerHeight; leftoverHeight > 0; leftoverHeight -= this.centerPatchSize.height()) {
                drawHeight = Math.min(this.centerPatchSize.height(), leftoverHeight);
                for (int leftoverWidth = width - doubleCornerWidth; leftoverWidth > 0; leftoverWidth -= this.centerPatchSize.width()) {
                    int drawWidth = Math.min(this.centerPatchSize.width(), leftoverWidth);
                    Drawer.m_93160_((PoseStack)matrices, (int)(x + this.cornerPatchSize.width() + leftoverWidth - drawWidth), (int)(y + this.cornerPatchSize.height() + leftoverHeight - drawHeight), (int)drawWidth, (int)drawHeight, (float)(this.u + this.cornerPatchSize.width() + this.centerPatchSize.width() - drawWidth), (float)(this.v + this.cornerPatchSize.height() + this.centerPatchSize.height() - drawHeight), (int)drawWidth, (int)drawHeight, (int)this.textureSize.width(), (int)this.textureSize.height());
                }
            }
        }
        if (width > doubleCornerWidth) {
            for (int leftoverWidth = width - doubleCornerWidth; leftoverWidth > 0; leftoverWidth -= this.centerPatchSize.width()) {
                int drawWidth = Math.min(this.centerPatchSize.width(), leftoverWidth);
                Drawer.m_93160_((PoseStack)matrices, (int)(x + this.cornerPatchSize.width() + leftoverWidth - drawWidth), (int)y, (int)drawWidth, (int)this.cornerPatchSize.height(), (float)(this.u + this.cornerPatchSize.width() + this.centerPatchSize.width() - drawWidth), (float)this.v, (int)drawWidth, (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
                Drawer.m_93160_((PoseStack)matrices, (int)(x + this.cornerPatchSize.width() + leftoverWidth - drawWidth), (int)(y + height - this.cornerPatchSize.height()), (int)drawWidth, (int)this.cornerPatchSize.height(), (float)(this.u + this.cornerPatchSize.width() + this.centerPatchSize.width() - drawWidth), (float)(this.v + bottomEdge), (int)drawWidth, (int)this.cornerPatchSize.height(), (int)this.textureSize.width(), (int)this.textureSize.height());
            }
        }
        if (height > doubleCornerHeight) {
            for (leftoverHeight = height - doubleCornerHeight; leftoverHeight > 0; leftoverHeight -= this.centerPatchSize.height()) {
                drawHeight = Math.min(this.centerPatchSize.height(), leftoverHeight);
                Drawer.m_93160_((PoseStack)matrices, (int)x, (int)(y + this.cornerPatchSize.height() + leftoverHeight - drawHeight), (int)this.cornerPatchSize.width(), (int)drawHeight, (float)this.u, (float)(this.v + this.cornerPatchSize.height() + this.centerPatchSize.height() - drawHeight), (int)this.cornerPatchSize.width(), (int)drawHeight, (int)this.textureSize.width(), (int)this.textureSize.height());
                Drawer.m_93160_((PoseStack)matrices, (int)(x + width - this.cornerPatchSize.width()), (int)(y + this.cornerPatchSize.height() + leftoverHeight - drawHeight), (int)this.cornerPatchSize.width(), (int)drawHeight, (float)(this.u + rightEdge), (float)(this.v + this.cornerPatchSize.height() + this.centerPatchSize.height() - drawHeight), (int)this.cornerPatchSize.width(), (int)drawHeight, (int)this.textureSize.width(), (int)this.textureSize.height());
            }
        }
    }
}

